
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Feb 07 09:42:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_sep.c#1:csrc:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/************* Include Files **************************************/
#include <stdio.h>
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"


#define TST_FAIL                       1
#define TST_PASS                       0
/************************ Public Functions *************************/
/*****************************************************************************
* Function Name:
*  KMNG_TST_CheckErrorReturn
*
* Inputs:
*  DxUint32_t  TST_ErrorRet - The return value of the checked function
*  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
*  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
*  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function Is a utility function to save up some space
* this function returns the appropriate printing for a checked function
* If the operation has succeeded of failed the appropriate printing and return value
*
******************************************************************************/
DxError_t ATP_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                   char       TST_FuncName[TST_FUNC_STRING_LEN],
                                   char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                   char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet != TST_PASS)
    {
        printf("\n !!!! TST_Error - Master Test Name - %s\n",TST_MasterTestName);
        printf("\n !!!! TST_Error - SubTest Name - %s\n",TST_SubTestName);
        printf("\n !!!! TST_Error - %s failed\n",TST_FuncName);
        printf("\n !!!! TST_Error - error returned %lX \n",TST_ErrorRet);
        return TST_FAIL;
    }
    else
    {
        printf("\n TST_message - %s pass \n",TST_FuncName);
        return DX_SUCCESS;
    }
}
/*****************************************************************************
 * Function Name:
 *  TST_CheckErrorReturn
 * 
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation had succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckErrorReturn(DxError_t TST_ErrorRet, char* TST_FuncName)
{
    if (TST_ErrorRet == TST_PASS)
    {
        printf("\n Test function - %s pass\n",TST_FuncName);
        return TESTPASS;
    }
    else
    {
        printf("\n Test function - %s failed, \n",TST_FuncName); 
        printf("\n Test Error - %x \n",TST_ErrorRet);

    return TESTFAIL;
    }
}

void ATP_LOG( DxUint8_t level , const char *format, ...)
{
    DX_VA_LIST ap;
    DX_VA_START(ap, format);

    printf(format, ap);
    DX_VA_END(ap);
}/* END OF ATP_LOG_TST */



